/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Varius Bolts
#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"
#include "section.h"
#include <math.h>



HRESULT CreateSquareBolt(double length, double dia)
{

	START_METHOD("CreateSquareBolt")

	HRESULT status = NOERROR;

	CString str1, str2, str3, ext1, ext2, ext3;
	int sketchCount = 1;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

//	GetSketchName(str1);
	str1.Format("sketch %d", ++sketchCount);


	ISketch *pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str1.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ISet *pRect = NULL;
	status = CreateRectangle(-dia/sqrt(2), -dia/sqrt(2),	dia/sqrt(2), dia/sqrt(2), &pRect);
	CHECK_RETURN_STATUS(status)

	IExtrusion *pDisp = NULL;
	GetExtrusionName(ext1);

	status = CreateExtrusion(pSketch, 0.8*dia, 1, 0, 0, 1, ext1.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)
	
	// Two commits are done, one after extrusion and another after updation.
	// this ensures updation. or else the design is not updated
	status = CommitToProDESKTOP("Extrusion1");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign1");
	CHECK_RETURN_STATUS(status)

//  draw circle in another sketch
//	GetSketchName(str2);
	str2.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str2.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	status = CreateCircle(0, 0, dia/sqrt(2.), &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext2);
	status = CreateExtrusion(pSketch, .8*dia, 1 , (-59*3.142/180), 0, 3, ext2.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion2");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign2");
	CHECK_RETURN_STATUS(status)

//	GetSketchName(str3);
	str3.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str3.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	status = CreateCircle(0, 0, dia/2, &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext3);
	status = CreateExtrusion(pSketch, length+0.8*dia, 1, 0, 0, 1, ext3.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion3");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign3");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateSquareBolt")
}

HRESULT CreateHexagonalBolt(double length, double dia)
{

	START_METHOD("CreateHexagonalBolt")

	HRESULT status = NOERROR;
	IExtrusion *pDisp = NULL;

	CString str1, str2, str3, ext1, ext2, ext3;

	double outerCircDia = (dia*sqrt(3.))/2;
	int sketchCount = 1;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

//	GetSketchName(str1);
	str1.Format("sketch %d", ++sketchCount);
	
	ISketch *pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str1.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pLine = NULL;
	status = CreateLine(dia, 0, dia/2, outerCircDia, &pLine);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(dia/2, outerCircDia, -dia/2, outerCircDia, &pLine);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(-dia/2, outerCircDia,  -dia, 0, &pLine);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(-dia, 0, -dia/2, -outerCircDia, &pLine);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(-dia/2, -outerCircDia, dia/2, -outerCircDia, &pLine);
	CHECK_RETURN_STATUS(status)

	status = CreateLine(dia/2, -outerCircDia, dia, 0, &pLine);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext1);
	status = CreateExtrusion(pSketch, 0.8*dia, 1, 0, 0, 1, ext1.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion1");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Updatedesign1");
	CHECK_RETURN_STATUS(status)

//  draw circle in another sketch
//	GetSketchName(str2);
	str2.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str2.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	status = CreateCircle(0, 0, outerCircDia, &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext2) ;
	status = CreateExtrusion(pSketch, .8*dia, 1, -59*3.142/180, 0, 3, ext2.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion2");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign2");
	CHECK_RETURN_STATUS(status)

//  draw circle in another sketch
//	GetSketchName(str3);
	str3.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str3.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	status = CreateCircle(0, 0, dia/2, &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext3) ;
	status = CreateExtrusion(pSketch, length+0.8*dia, 1, 0, 0, 1, ext3.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion3");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign3");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateHexagonalBolt")
}

HRESULT CreateSquareHeadedBolt(double length, double dia)
{

	START_METHOD("CreateSquareHeadedBolt")

	HRESULT status = NOERROR;	
	
	CString str1, str2, str3, str4, ext1, ext2, ext3, ext4;
	int sketchCount = 1;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IExtrusion *pDisp = NULL;
//	GetSketchName(str1);
	str1.Format("sketch %d", ++sketchCount);

	ISketch *pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str1.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)
	
	ISet *pRect = NULL;
	status = CreateRectangle(-dia/sqrt(2), -dia/sqrt(2),	dia/sqrt(2), dia/sqrt(2), &pRect);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext1);

	status = CreateExtrusion(pSketch, 0.8*dia, 1, 0, 0, 1, ext1.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion1");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign1");
	CHECK_RETURN_STATUS(status)

	// draw circle in another sketch
//	GetSketchName(str2);
	str2.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str2.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;	
	status = CreateCircle(0, 0, dia/sqrt(2), &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext2);
	status = CreateExtrusion(pSketch, 0.8*dia, 1, (-55*3.1432/180), 0, 3, ext2.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion2");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign2");
	CHECK_RETURN_STATUS(status)
		
//	GetSketchName(str3);
	str3.Format("sketch %d", ++sketchCount);

	status = NewSketch(activeWorkplane, 6, str3.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	status = CreateRectangle(-dia/2, -dia/2, dia/2, dia/2, &pRect);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext3);

	status = CreateExtrusion(pSketch, 2.*0.8*dia, 1, 0, 0, 1, ext3.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion3");
	CHECK_RETURN_STATUS(status)

	activePart->UpdateDesign();
	
	status = CommitToProDESKTOP("UpdateDesign3");
	CHECK_RETURN_STATUS(status)

//	GetSketchName(str4);
	str4.Format("sketch %d", ++sketchCount);
	
	status = NewSketch(activeWorkplane, 6, str4.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	status = CreateCircle(0, 0, dia/2., &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext4);
	status = CreateExtrusion(pSketch, length+0.8*dia, 1, 0, 0, 1, ext4.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion4");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign4");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateSquareHeadedBolt")
}

HRESULT CreateTeeHeadedBolt(double length, double dia)
{

	START_METHOD("CreateTeeHeadedBolt")

	HRESULT status = NOERROR;
	
	CString str1, str2, str3, ext1, ext2, ext3;
	int sketchCount = 1;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IExtrusion *pDisp = NULL;
//	GetSketchName(str1);
	str1.Format("sketch %d", ++sketchCount);
	
	ISketch *pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str1.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ISet *pRect = NULL;
	status = CreateRectangle(-dia/2, -(dia*9/10), dia/2, dia*9/10, &pRect);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext1);

	status = CreateExtrusion(pSketch, 0.8*dia, 1, 0, 0, 1, ext1.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	// draw circle in another sketch
//	GetSketchName(str2);
	str2.Format("sketch %d", ++sketchCount);
	pSketch = NULL;

	status = NewSketch(activeWorkplane, 6, str2.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	pRect = NULL;
	status = CreateRectangle(-dia/2, -dia/2,	dia/2, dia/2, &pRect);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext2);
	status = CreateExtrusion(pSketch, 2*0.8*dia, 1, 0, 0, 1, ext2.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion1");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

//	GetSketchName(str3);
	str3.Format("sketch %d", ++sketchCount);

	pSketch = NULL;
	status = NewSketch(activeWorkplane, 6, str3.AllocSysString(), &pSketch);
	CHECK_RETURN_STATUS(status)

	ILine *pCircle = NULL;
	status = CreateCircle(0, 0, dia/2., &pCircle);
	CHECK_RETURN_STATUS(status)

	pDisp = NULL;
	GetExtrusionName(ext3);
	status = CreateExtrusion(pSketch, length+0.8*dia, 1, 0, 0, 1, ext3.AllocSysString(), &pDisp);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion2");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign2");
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateTeeHeadedBolt")
}

HRESULT GetSketchName(CString& newSketchName) 
{

	START_METHOD("GetSketchName")

	HRESULT status=CONV_SUCCESS;
	char name[128];
	int num = 0;

	int maxFound = 0;
	long count, sketchCount;
	BSTR skName;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign= NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	ISet *pWorkplaneSet= NULL;
	status = pDesign->GetWorkplanes(&pWorkplaneSet);
	CHECK_RETURN_STATUS(status)

	status = pWorkplaneSet->GetCount(&count);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pWorkplaneSet,&pObjectIt);
	CHECK_RETURN_STATUS(status)

	/*
		Iterate through all the available workplanes and sketches
		and hide all the sketches except the active sketch.
	*/
	IDispatch *pDispWp= NULL;
	status = pObjectIt->start(&pDispWp);
	CHECK_RETURN_STATUS(status)

	for(long i=0; i <= count-1; i++) {
		// Get the total number of sketches
		
		IWorkplane *currentWorkplane = CAST(IWorkplane, pDispWp);

		ISet *sketchSet=NULL;
		status = currentWorkplane->GetSketches(&sketchSet);

		if(!sketchSet)
			continue ;

		CHECK_RETURN_STATUS(status)
		
		IIt *pSketchSetIt = NULL;
		status = (GetCLASS(It))->CreateAObjectIt(sketchSet,&pSketchSetIt);
		CHECK_RETURN_STATUS(status)

		IDispatch *pSketch = NULL;
		status = pSketchSetIt->start(&pSketch);
		CHECK_RETURN_STATUS(status)
		
		if (!pSketch) 
			return CONV_SUCCESS;

		status = sketchSet->GetCount(&sketchCount);
		CHECK_RETURN_STATUS(status)

		for(long a=0; a <= sketchCount-1; a++) {
			ISketch *sketch = CAST(ISketch, pSketch); 

			sketch->GetName(&skName);
			CHECK_RETURN_STATUS(status)

			CString strName(skName);

			if(sscanf(strName, "%s%d",  name,  &num) != 2)
				continue ; // proceed with next sketch

			if(strcmp(name, "sketch") != 0)
				continue ; // proceed with next sketch

			if(num > maxFound)
				maxFound = num;

			pSketch = NULL;
			status = pSketchSetIt->Next(&pSketch);
			CHECK_RETURN_STATUS(status)

   		}
		pDispWp = NULL;
		status = pObjectIt->Next(&pDispWp);
		CHECK_RETURN_STATUS(status)
	}
	newSketchName.Format("sketch %d", maxFound+1);

	END_METHOD("GetSketchName")
}

HRESULT GetExtrusionName(CString& newExtrusionName) 
{

	START_METHOD("GetExtrusionName")

	HRESULT status = CONV_SUCCESS;
	int num = 1;
	CString  extrusionName;

	IWorkplane *l_currentWorkplane=NULL;

	IOperation *pOperation = NULL;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)
	
	while(TRUE) {
		extrusionName.Format("extrusion %d", num);
		status = activePart->LookupOperation(extrusionName.AllocSysString(),&pOperation);
		if(!pOperation) {
			break;	
		}
		num = num + 1;
	}
	newExtrusionName.Format("extrusion %d", num);

	END_METHOD("GetExtrusionName")
}
